//+------------------------------------------------------------------+
//|                                               ControlsDialog.mqh |
//|                                           Copyright 2015, MigVRN |
//|                                                    Miguzov@bk.ru |
//+------------------------------------------------------------------+
#include <Controls\Dialog.mqh>
#include "BmpButtonTransparent.mqh"

//+------------------------------------------------------------------+
//| defines                                                          |
//+------------------------------------------------------------------+
//--- indents and gaps
#define INDENT_LEFT                         (11)      // indent from left (with allowance for border width)
#define INDENT_TOP                          (11)      // indent from top (with allowance for border width)

//+------------------------------------------------------------------+
//| Resources                                                        |
//+------------------------------------------------------------------+
#resource "\\Images\\200_1.bmp"
#resource "\\Images\\200_2.bmp"
#resource "\\Images\\200_3.bmp"
#resource "\\Images\\200_4.bmp"
//+------------------------------------------------------------------+
//| Class CControlsDialog                                            |
//| Usage: main dialog of the Controls application                   |
//+------------------------------------------------------------------+
class CControlsDialog : public CAppDialog
  {
private:
   CBmpButtonTransparent m_Button[9];                        // the button object

   //---BMP for button
   string            m_On_Passive_name;
   string            m_On_Active_name;
   string            m_Off_Passive_name;
   string            m_Off_Active_name;

public:
                     CControlsDialog(void);
                    ~CControlsDialog(void);
   //--- create
   virtual bool      Create(const long chart,const string name,const int subwin,const int _x1,const int _y1,const int _x2,const int _y2);
   //--- chart event handler
   virtual bool      OnEvent(const int id,const long &lparam,const double &dparam,const string &sparam);

protected:
   //--- create dependent controls
   bool              CreateButton(void);

   //--- handlers of the dependent controls events
   bool              OnClickButton(const int index);
  };
//+------------------------------------------------------------------+
//| Event Handling                                                   |
//+------------------------------------------------------------------+
EVENT_MAP_BEGIN(CControlsDialog)
ON_INDEXED_EVENT(ON_CLICK,m_Button,OnClickButton)
EVENT_MAP_END(CAppDialog)
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CControlsDialog::CControlsDialog(void)
  {
   m_Off_Passive_name= "::Images\\200_1.bmp";
   m_Off_Active_name = "::Images\\200_2.bmp";
   m_On_Passive_name= "::Images\\200_3.bmp";
   m_On_Active_name = "::Images\\200_4.bmp";
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CControlsDialog::~CControlsDialog(void)
  {
  }
//+------------------------------------------------------------------+
//| Create                                                           |
//+------------------------------------------------------------------+
bool CControlsDialog::Create(const long chart,const string name,const int subwin,const int _x1,const int _y1,const int _x2,const int _y2)
  {
   if(!CAppDialog::Create(chart,name,subwin,_x1,_y1,_x2,_y2))
      return(false);

//--- create dependent controls
   if(!CreateButton())
      return(false);

//--- succeed
   return(true);
  }
//+------------------------------------------------------------------+
//| Create the "Button" button                                      |
//+------------------------------------------------------------------+
bool CControlsDialog::CreateButton(void)
  {
//--- Get width and height BMP file
   uint width;
   uint height;
   if(!m_Button[0].GetWidthAndHeightBmp(m_Off_Passive_name,width,height))
      return(false);

//--- Set first coordinates
   int x1 = INDENT_LEFT;
   int x2 = x1+(int)width;
   int y1 = INDENT_TOP;
   int y2 = y1+(int)height;

//---Counter columns   
   int count_columns=0;

//--- Create button
   for(int i=0; i<9; i++)
     {
      //--- Create button  
      if(!m_Button[i].Create(m_chart_id,m_name+"_Button["+(string)i+"]",m_subwin,x1,y1,x2,y2))
         return(INIT_FAILED);

      //---Set next coordinates
      count_columns++;
      if(count_columns>2)
        {
         count_columns=0;
         x1 = INDENT_LEFT;
         x2 = x1+(int)width;
         y1+= (int)height-48;
         y2 = y1+(int)height;
        }
      else
        {
         x1+= (int)width-48;
         x2 = x1+(int)width;
        }

      //--- Set Bmp images for button
      if(!m_Button[i].BmpOffPassiveName(m_Off_Passive_name))
         return(false);
      if(!m_Button[i].BmpOffActiveName(m_Off_Active_name))
         return(false);
      if(!m_Button[i].BmpOnPassiveName(m_On_Passive_name))
         return(false);
      if(!m_Button[i].BmpOnActiveName(m_On_Active_name))
         return(false);

      //--- Set transparent for button
      if(!m_Button[i].SetTransparent(m_Off_Passive_name))
         return(false);

      //---Set width of border button    
      if(!m_Button[i].Border(0))
         return(false);

      //---Set type and state button
      m_Button[i].Locking(true);
      m_Button[i].Pressed(false);


      if(!Add(m_Button[i]))
      return(false);

      //---Refresh bmp afther all settings   
      if(!m_Button[i].RefreshBmp())
         return(false);
     }

//--- succeed
   return(true);
  }
//+------------------------------------------------------------------+
//| Event handler                                                  |
//+------------------------------------------------------------------+
bool CControlsDialog::OnClickButton(const int index)
  {
   m_Button[index].Press();

   if(m_Button[index].Pressed())
      Comment("Button ",index," - ON");
   else
      Comment("Button ",index," - OFF");

   return(true);
  }
//+------------------------------------------------------------------+
